//
//  AHKUtilityController.m
//  AH-K3001V Utilities
//
//  Created by FUJIDANA on Fri Apr 16 2005.
//  Copyright (c) 2005 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "AHKUtilityController.h"
#import "AHKPhone.h"

@implementation AHKUtilityController

static NSString *AHKDefaultsAllowsLaunchingWithoutDriverKey = @"AHKAllowsLaunchingWithoutDriver";

+ (void)initialize
{
    NSUserDefaults	*defaults			= [NSUserDefaults standardUserDefaults];
	
    NSDictionary	*appDefaults		= [NSDictionary dictionaryWithObject:[NSNumber numberWithBool:NO] forKey:AHKDefaultsAllowsLaunchingWithoutDriverKey];
    [defaults registerDefaults:appDefaults];
}

#pragma mark delegated by NSApplication
//- (BOOL)application:(NSApplication *)theApplication openFile:(NSString *)filename
//{
//	
//}


- (void)applicationWillFinishLaunching:(NSNotification *)aNotification
{
	NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
	
	if ([userDefaults boolForKey:AHKDefaultsAllowsLaunchingWithoutDriverKey] == NO && [AHKPhone existsDriver] == NO) {
		NSString *driverName  = [AHKPhone humanReadableDriverName];
		NSString *message     = NSLocalizedString(@"Couldn't use this application because the %@ didn't exist.", @"driverNotFoundAlert.message");
		NSString *information = NSLocalizedString(@"You need to install the %@ or later. The application will be quited.", @"driverNotFoundAlert.information");
	
		NSAlert *alert = [[[NSAlert alloc] init] autorelease];
		[alert addButtonWithTitle:NSLocalizedString(@"Quit", @"driverNotFoundAlert.firstButton")];
		[alert setMessageText:[NSString stringWithFormat:message, driverName]];
		[alert setInformativeText:[NSString stringWithFormat:information, driverName]];
		[alert setAlertStyle:NSCriticalAlertStyle];
		[alert runModal];
		[NSApp terminate:self];
	}
	
	[preferencesWindow center];
}

- (void)applicationWillTerminate:(NSNotification *)aNotification
{
	// The following code is needed to invoke windowWillClose: delegate methods of window controllers.
	// If you omit this code, windowWillClose: is not invoked and user defaults might not be stored when application quits.
	NSArray			*windows	= [[NSApplication sharedApplication] windows];
	NSEnumerator	*enumerator	= [windows objectEnumerator];
	NSWindow		*window;
	
	while (window = [enumerator nextObject]) {
		if ([window isVisible]) {
			[window performClose:self];
		}
	}
}

- (BOOL)application:(NSApplication *)theApplication openFile:(NSString *)filename
{
	if (addressBookWindowController && ([[filename lowercaseString] hasSuffix:@"ahkabbuckup"] || [[filename lowercaseString] hasSuffix:@"ahkabbu"])) {
		[addressBookWindowController showWindow:nil];
		[addressBookWindowController performSelector:@selector(confirmRevertDatabaseFromFile:) withObject:filename];
		return YES;
	} else if (mailWindowController && [[filename lowercaseString] hasSuffix:@"ahkmbu"]) {
		[mailWindowController showWindow:nil];
		[mailWindowController performSelector:@selector(confirmRevertDatabaseFromFile:) withObject:filename];
		return YES;
	}
	
	return NO;
}

/*
- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)theApplication
{
	return YES;
}
*/

#pragma mark IBActions

- (IBAction)launchAddressUtility:(id)sender
{
	if ([[NSWorkspace sharedWorkspace] launchApplication:@"Kyopon Address Utility"] == NO) {
		NSString *appName		= NSLocalizedString(@"Kyopon Address Utility", @"addressUtility.fullAppName");
		NSString *message		= NSLocalizedString(@"%@ cannot be launched.", @"failToLaunchRelatedUtilityAlert.message");
		NSString *information	= NSLocalizedString(@"%@ might not be installed, renamed, or moved into the trash.", @"failToLaunchRelatedUtilityAlert.information");
		
		NSAlert *alert = [[[NSAlert alloc] init] autorelease];
		[alert setMessageText:[NSString stringWithFormat:message, appName]];
		[alert setInformativeText:[NSString stringWithFormat:information, appName]];
		[alert setAlertStyle:NSWarningAlertStyle];
		[alert runModal];
	}
}

- (IBAction)launchBookmarkUtility:(id)sender
{
	NSWorkspace		*workspace			= [NSWorkspace sharedWorkspace];
	NSFileManager	*fileManager		= [NSFileManager defaultManager];
	
	NSString		*bookmarkAppName	= @"Kyopon Bookmark Utility";
	
	NSString		*dataFolderPath		= [[[NSHomeDirectory() stringByAppendingPathComponent:@"Library"]
		stringByAppendingPathComponent:@"Application Support"]
		stringByAppendingPathComponent:@"AH-K3001V Utilities"];
	NSString		*filePath			= [dataFolderPath stringByAppendingPathComponent:@"Bookmarks.airh-bookmarks"];
	NSString		*localizedFilePath	= [dataFolderPath stringByAppendingPathComponent:NSLocalizedString(@"Bookmarks.airh-bookmarks", nil)];
	
	if ([fileManager fileExistsAtPath:localizedFilePath] && [workspace openFile:localizedFilePath withApplication:bookmarkAppName]) {
		return;
	} else if ([fileManager fileExistsAtPath:filePath] && [workspace openFile:filePath withApplication:bookmarkAppName]) {
		return;
	} else if ([workspace launchApplication:bookmarkAppName]) {
		return;
	} else {
		NSString *appName		= NSLocalizedString(@"Kyopon Bookmark Utility", @"bookmarkUtility.fullAppName");
		NSString *message		= NSLocalizedString(@"%@ cannot be launched.", @"failToLaunchRelatedUtilityAlert.message");
		NSString *information	= NSLocalizedString(@"%@ might not be installed, renamed, or moved into the trash.", @"failToLaunchRelatedUtilityAlert.information");
		
		NSAlert *alert = [[[NSAlert alloc] init] autorelease];
		[alert setMessageText:[NSString stringWithFormat:message, appName]];
		[alert setInformativeText:[NSString stringWithFormat:information, appName]];
		[alert setAlertStyle:NSWarningAlertStyle];
//		[alert setIcon:<#(NSImage *)icon#>];
		[alert runModal];
	}
}

- (IBAction)launchFileUtility:(id)sender
{
	if ([[NSWorkspace sharedWorkspace] launchApplication:@"Kyopon File Utility"] == NO) {
		NSString *appName		= NSLocalizedString(@"Kyopon File Utility", @"fileUtility.fullAppName");
		NSString *message		= NSLocalizedString(@"%@ cannot be launched.", @"failToLaunchRelatedUtilityAlert.message");
		NSString *information	= NSLocalizedString(@"%@ might not be installed, renamed, or moved into the trash.", @"failToLaunchRelatedUtilityAlert.information");
		
		NSAlert *alert = [[[NSAlert alloc] init] autorelease];
		[alert setMessageText:[NSString stringWithFormat:message, appName]];
		[alert setInformativeText:[NSString stringWithFormat:information, appName]];
		[alert setAlertStyle:NSWarningAlertStyle];
//		[alert setIcon:<#(NSImage *)icon#>];
		[alert runModal];
	}
}

- (IBAction)launchMailUtility:(id)sender
{
	if ([[NSWorkspace sharedWorkspace] launchApplication:@"Kyopon Mail Utility"] == NO) {
		NSString *appName		= NSLocalizedString(@"Kyopon Mail Utility", @"mailUtility.fullAppName");
		NSString *message		= NSLocalizedString(@"%@ cannot be launched.", @"failToLaunchRelatedUtilityAlert.message");
		NSString *information	= NSLocalizedString(@"%@ might not be installed, renamed, or moved into the trash.", @"failToLaunchRelatedUtilityAlert.information");
		
		NSAlert *alert = [[[NSAlert alloc] init] autorelease];
		[alert setMessageText:[NSString stringWithFormat:message, appName]];
		[alert setInformativeText:[NSString stringWithFormat:information, appName]];
		[alert setAlertStyle:NSWarningAlertStyle];
//		[alert setIcon:<#(NSImage *)icon#>];
		[alert runModal];
	}
}

@end
